<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Record extends Model 
{

    protected $table = 'records';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('battery_level', 'density', 'depotage', 'env_temperature', 'level', 'liquid_height', 'liquid_temperature', 'sensor_reference', 'tank_id', 'total_volume', 'volume', 'volume_at_fift');
    protected $visible = array('battery_level', 'density', 'depotage', 'env_temperature', 'level', 'liquid_height', 'liquid_temperature', 'sensor_reference', 'tank_id', 'total_volume', 'volume', 'volume_at_fift');

    public function tank()
    {
        return $this->belongsTo('Tank', 'tank_id');
    }

}